
# 1 Redis Sentinal机制
sentinal，中文名哨兵

哨兵是redis集群架构中非常重要的一个组件，主要功能如下
- 集群监控
监控Redis master和slave进程的正常工作
- 消息通知
如果某个Redis实例有故障，那么哨兵负责发送报警消息给管理员
- 故障转移
若master node宕机，会自动转移到slave node上
- 配置中心
若发生故障转移，通知client客户端新的master地址

哨兵本身也是分布式的，作为一个哨兵集群去运行，协同工作
- 故障转移时，判断一个master node是否宕机，需要大部分的哨兵都同意，涉及到了分布式选举问题
- 即使部分哨兵节点宕机，哨兵集群还是能正常工作的


> 目前采用的是sentinal 2版本，sentinal 2相对于sentinal 1来说，重写了很多代码，主要是让故障转移的机制和算法变得更加健壮和简单

# 2 哨兵的核心知识
1. 哨兵需要至少3个实例，保证自己的健壮性
2. 哨兵 + Redis主从的部署架构，是不会保证数据零丢失的，只能保证redis集群的高可用性
3. 对于哨兵 + Redis主从这种复杂的部署架构，尽量在测试环境和生产环境，都进行充足的测试和演练

# 3 为什么仅2个节点时无法正常工作
必须部署2个以上的节点

若仅部署2个实例，quorum=1

```
+----+         +----+
| M1 |---------| R1 |
| S1 |         | S2 |
+----+         +----+
```

Configuration: `quorum = 1`


master宕机，s1和s2中只要有1个哨兵认为master宕机就可以进行切换，同时会在s1和s2中选举出一个执行故障转移.
但此时，需要majority，也就是大多数哨兵都是运行的，2个哨兵的majority就是2

> 2个哨兵的majority=2
> 3个哨兵的majority=2
> 4个哨兵的majority=2
> 5个哨兵的majority=3

2个哨兵都运行着，就可以允许执行故障转移

若整个M1和S1运行的机器宕机了，那么哨兵仅剩1个，此时就无majority来允许执行故障转移，虽然另外一台机器还有一个R1，但故障转移不会执行

# 4 3-节点哨兵集群(经典)
```
       +----+
       | M1 |
       | S1 |
       +----+
          |
+----+    |    +----+
| R2 |----+----| R3 |
| S2 |         | S3 |
+----+         +----+
```
Configuration: quorum = 2，majority

若M1节点宕机了，还剩下2个哨兵，S2和S3可以一致认为master宕机了，然后选举出一个来执行故障转移

同时3个哨兵的`majority`是2，所以余存的2个哨兵运行着，就可执行故障转移



# 参考

《Java工程师面试突击第1季-中华石杉老师》

# X 交流学习
![](https://img-blog.csdnimg.cn/20190504005601174.jpg)
## [Java交流群](https://jq.qq.com/?_wv=1027&k=5UB4P1T)
## [博客](http://www.shishusheng.com)
## [Github](https://github.com/Wasabi1234)